---  Hilfsfunktionen zum PSQL-Script erstellen

--- Funktion liefert Trigger-Name von bestehendes Auditlog-Trigger
CREATE OR REPLACE FUNCTION tlog.Audotlog__Triggername( IN _tname varchar ) RETURNS VARCHAR AS $$
  DECLARE result      varchar := '';
  BEGIN

      SELECT tgname INTO result FROM pg_trigger WHERE tgname iLIKE _tname || '__a_99_%' AND tgname iLIKE '%__auditlog';

      RETURN result;
  END $$ LANGUAGE plpgsql STABLE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog_parent_fname(_tabname varchar)
  RETURNS varchar
  AS $$
  DECLARE _fname varchar;
  BEGIN

    SELECT lon_parent_fname INTO _fname FROM tlog.AuditlogConfig_ON WHERE lon_table = _tabname;
    IF _fname IS NULL THEN
        RAISE EXCEPTION '%', lang_text( 29830 );   --- ACHTUNG !!!  Unerwarteter Fehler. Frage bitte den Entwickler
    END IF;
    RETURN _fname;

  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tlog.auditlog__table_trigger__from__AuditlogConfig_ON__create__rec(
        IN _tname varchar DEFAULT null,
        IN _dbu boolean DEFAULT false,

        OUT line_  TEXT,
        OUT line1_ TEXT
    ) RETURNS setof record AS $$
 DECLARE rec                 record;
         rec_on              record;
         _triggername_neu    varchar;
         _triggername_alt    varchar;
         _str                varchar;
         _OF_str             text    := '';
         _OF_i               integer := 0;
         i                   integer := 0;
         _rec_count          integer := 0;
         _schema             varchar := '';
         _prefix             varchar := '';
 BEGIN
    line1_ := '';

    IF _dbu THEN
        line_ := '--- alle Auditlog-Trigger löschen';                                                RETURN NEXT;
        line_ := 'DROP FUNCTION tlog.Auditlog_add_record() CASCADE;';                       RETURN NEXT;
        line_ := '--- FUNCTION tlog.Auditlog_add_record() einspielen';                      RETURN NEXT;
        line_ := 'SELECT tlog.Auditlog_add_record__create();';                              RETURN NEXT;
        line_ := '---';                                                                     RETURN NEXT;
        line_ := '--- FUNCTION tlog.log__json__old_new__compare() einspielen';              RETURN NEXT;
        line_ := 'SELECT tlog.log__json__old_new__compare();';                              RETURN NEXT;
        line_ := '---';                                                                     RETURN NEXT;
    END IF;

    FOR rec_on IN SELECT *
                  FROM tlog.AuditlogConfig_ON
                  WHERE CASE WHEN _tname IS NOT null THEN
                            lon_table = _tname
                        ELSE
                            lon_table iLIKE '%'
                        END
                    AND not lon_inaktiv        --- deaktivierte Tabellen ausschliessenND
                  ORDER BY lon_table
    LOOP

        _triggername_neu := rec_on.lon_table || '__a_99_';

        IF NOT EXISTS( SELECT true FROM tlog.AuditlogConfig_ON WHERE lon_table = rec_on.lon_table AND ( lon_log_insert OR lon_log_update OR lon_log_delete ) ) THEN   --- keine Logging
            EXIT;
        END IF;

        IF NOT EXISTS( SELECT true FROM tlog.AuditlogConfig_OF WHERE lof_table = rec_on.lon_table AND lof_logging ) THEN   --- keine Felder zum loggen
            EXIT;
        END IF;

        ---  Triggername-Prefix erstellen
        IF EXISTS( SELECT true FROM tlog.AuditlogConfig_ON WHERE lon_table = rec_on.lon_table AND ( lon_log_insert ) ) THEN
            _triggername_neu := _triggername_neu || 'i';
        END IF;

        IF EXISTS( SELECT true FROM tlog.AuditlogConfig_ON WHERE lon_table = rec_on.lon_table AND ( lon_log_update ) ) THEN
            _triggername_neu := _triggername_neu || 'u';
        END IF;

        IF EXISTS( SELECT true FROM tlog.AuditlogConfig_ON WHERE lon_table = rec_on.lon_table AND ( lon_log_delete ) ) THEN
            _triggername_neu := _triggername_neu || 'd';
        END IF;
        ---
        --- Tableschema einlesen
        SELECT table_schema INTO _schema FROM information_schema.tables WHERE table_name = rec_on.lon_table;

        --- alte Trigger-Name einlesen
        SELECT * FROM tlog.Audotlog__Triggername( rec_on.lon_table ) INTO _triggername_alt;

        _triggername_neu := _triggername_neu || '__auditlog';

        line_ := 'CREATE TRIGGER ' || _triggername_neu;                        RETURN NEXT;

        _str := 'AFTER ';
        IF ( SELECT lon_log_insert FROM tlog.AuditlogConfig_ON WHERE lon_table = rec_on.lon_table ) THEN
            _triggername_neu := _triggername_neu || 'i';
            _str := _str || 'INSERT ';
        END IF;

        IF ( SELECT lon_log_update FROM tlog.AuditlogConfig_ON WHERE lon_table = rec_on.lon_table ) THEN
            _triggername_neu := _triggername_neu || 'u';
            IF length( _str ) > 8 THEN
                _str := _str || 'OR ';
            END IF;
            _str := _str || 'UPDATE ';
        END IF;
        line_ := rtrim( _str );          RETURN NEXT;

        SELECT count(*) INTO _rec_count FROM tlog.AuditlogConfig_OF WHERE lof_table = rec_on.lon_table AND lof_logging;

        --- Felder-Liste anlegen
        IF _rec_count > 0 AND ( SELECT count(*) FROM tlog.AuditlogConfig_OF WHERE lof_table = rec_on.lon_table ) <> _rec_count  THEN
            _OF_str := 'OF ';
            i       := 0;
            _OF_i   := 0;
            FOR rec IN SELECT * FROM tlog.AuditlogConfig_OF WHERE lof_table = rec_on.lon_table AND lof_logging LOOP
                i := i + 1;
                _OF_str := _OF_str || rec.lof_fieldname;
                IF i < _rec_count THEN
                    _OF_str := _OF_str ||  ', ';
                END IF;
                IF char_length( _OF_str ) > 150 OR i = _rec_count THEN
                    IF _OF_i = 0 THEN
                        line_ := ' '    || _OF_str;
                    ELSE
                        line_ := '    ' || _OF_str;
                    END IF;
                    _OF_i = _OF_i + 1;
                    RETURN NEXT;
                    _OF_str := '';
                END IF;
            END LOOP;

        END IF;

        IF ( SELECT lon_log_delete FROM tlog.AuditlogConfig_ON WHERE lon_table = rec_on.lon_table ) THEN
            _triggername_neu := _triggername_neu || 'd';
            IF length( _str ) > 8 THEN
                line_ := '  OR ';
            END IF;
            line_ := line_ || 'DELETE ';
            RETURN NEXT;
        END IF;

        IF _schema = 'public' THEN
            line_ := '  ON ' || rec_on.lon_table;                              RETURN NEXT;
        ELSE
            line_ := '  ON '  || _schema || '.'|| rec_on.lon_table;            RETURN NEXT;
        END IF;
        line_ := '  FOR EACH ROW';                                             RETURN NEXT;
        IF ( SELECT lon_when FROM tlog.AuditlogConfig_ON WHERE lon_table = rec_on.lon_table ) IS NOT null THEN
            line_ := '  ' || ( SELECT lon_when FROM tlog.AuditlogConfig_ON WHERE lon_table = rec_on.lon_table );            RETURN NEXT;
        END IF;

        line_ := '  EXECUTE PROCEDURE tlog.auditlog_add_record();';            RETURN NEXT;
        line_ := '---';                                                        RETURN NEXT;
    END LOOP;

 END $$ LANGUAGE plpgsql STABLE;
---

--- Triggescript erstellen als Text für Tabelle _tname und dann wird in Tabelle AuditlogConfig_ON.lon_trigger_script gespeichert
CREATE OR REPLACE FUNCTION tlog.auditlog__table_trigger__from__AuditlogConfig_ON__create__txt( IN _tname varchar ) RETURNS text AS $$
 DECLARE rec                 record;
         _triggername_neu    varchar := _tname || '__a_99_';
         _str                varchar;                            --- Scriptstring
         _OF_str             text    := '';
         _OF_i               integer := 0;
         i                   integer := 0;
         _rec_count          integer := 0;
         _schema             varchar := '';
         result              text := '';
 BEGIN
    --- Trigger mit WHEN-Klause und lon_log_delete, soll zwei new und old erhalten
    IF EXISTS( SELECT true FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname AND lon_when IS NOT null ) AND ( SELECT lon_log_delete FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname ) THEN
        SELECT * INTO result FROM tlog.auditlog__table_trigger__from__AuditlogConfig_ON__create__when_is_not_null__txt( _tname );
        RETURN result;
    END IF;

    IF NOT EXISTS( SELECT true FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname AND ( lon_log_insert OR lon_log_update OR lon_log_delete ) ) THEN   --- keine Logging
        RETURN result;
    END IF;

    IF NOT EXISTS( SELECT true FROM tlog.AuditlogConfig_OF WHERE lof_table = _tname AND lof_logging ) THEN   --- keine Felder zum loggen
        RETURN result;
    END IF;

    --- Tabellenschema einlesen
    SELECT table_schema INTO _schema FROM information_schema.tables WHERE table_name = _tname;

    _str := ' AFTER ';
    IF ( SELECT lon_log_insert FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname ) THEN
        _triggername_neu := _triggername_neu || 'i';
        _str := _str || 'INSERT ';
    END IF;

    IF ( SELECT lon_log_update FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname ) THEN
        _triggername_neu := _triggername_neu || 'u';
        IF length( _str ) > 8 THEN
            _str := _str || 'OR ';
        END IF;
        _str := _str || 'UPDATE ';
    END IF;

    SELECT count(*) INTO _rec_count FROM tlog.AuditlogConfig_OF WHERE lof_table = _tname AND lof_logging;
    --- Felder-Liste anlegen
    _OF_str := 'OF ';
    _OF_i   := 0;
    IF _rec_count > 0 AND ( SELECT count(*) FROM tlog.AuditlogConfig_OF WHERE lof_table = _tname ) <> _rec_count  THEN     --- OF - Felderliste anlegen, wenn reccount > 0 ist
                                                                                                                           --- oder wenn nicht alle Felder von Subtabelle ins Trigger gehen soll,
                                                                                                                           --- sonst keine OF-Kaluse
        i := 0;
        FOR rec IN SELECT * FROM tlog.AuditlogConfig_OF WHERE lof_table = _tname AND lof_logging ORDER BY lof_fieldname LOOP
            i := i + 1;
            _OF_str := _OF_str || rec.lof_fieldname;
            IF i < _rec_count THEN
                _OF_str := _OF_str ||  ', ';
            END IF;
            IF char_length( _OF_str ) > 150 OR i = _rec_count THEN
                IF _OF_i = 0 THEN
                    _str := _str ||  ' '    || _OF_str || chr( 10 );
                ELSE
                    _str := _str ||  '      ' || _OF_str || chr( 10 );
                END IF;
                _OF_i = _OF_i + 1;
                _OF_str := '';
            END IF;
        END LOOP;

    END IF;

    IF ( SELECT lon_log_delete FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname ) THEN
        _triggername_neu := _triggername_neu || 'd';
        IF _OF_i > 0 THEN
            _str := _str || ' ';
        END IF;
        _str := _str || 'OR DELETE ';
    END IF;

    _triggername_neu := _triggername_neu || '__auditlog';

    result := result ||  'CREATE TRIGGER ' || _triggername_neu || chr( 10 );
    result := result || _str || chr( 10 );

    IF _schema = 'public' THEN
        result := result ||  ' ON ' || _tname || chr( 10 );
    ELSE
        result := result ||  ' ON ' || _schema || '.' || _tname || chr( 10 );
    END IF;
    result := result ||  ' FOR EACH ROW'  || chr( 10 );

    IF ( SELECT lon_when FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname ) IS NOT null THEN
        result := result || ' ' || ( SELECT lon_when FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname ) || chr( 10 );
    END IF;
    result := result ||  ' EXECUTE PROCEDURE tlog.auditlog_add_record();'; -- || chr( 10 );

    RETURN result;

 END $$ LANGUAGE plpgsql STABLE;
 ---
 --- Trigger mit WHEN-Klause und lon_log_delete, soll zwei new und old erhalten
CREATE OR REPLACE FUNCTION tlog.auditlog__table_trigger__from__AuditlogConfig_ON__create__when_is_not_null__txt( IN _tname varchar ) RETURNS text AS $$
 DECLARE rec                 record;
         _triggername_neu    varchar := _tname || '__a_99_';
         _str                varchar;
         _OF_str             text    := '';
         _OF_i               integer := 0;
         i                   integer := 0;
         _rec_count          integer := 0;
         _schema             varchar := '';
         result              text := '';
 BEGIN

    IF NOT EXISTS( SELECT true FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname AND ( lon_log_insert OR lon_log_update OR lon_log_delete ) ) THEN   --- keine Logging
        RETURN result;
    END IF;

    IF NOT EXISTS( SELECT true FROM tlog.AuditlogConfig_OF WHERE lof_table = _tname AND lof_logging ) THEN   --- keine Felder zum loggen
        RETURN result;
    END IF;

    SELECT table_schema INTO _schema FROM information_schema.tables WHERE table_name = _tname;

    --- INSERT, UPDATE
    _str := ' AFTER ';
    IF ( SELECT lon_log_insert FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname ) THEN
        _triggername_neu := _triggername_neu || 'i';
        _str := _str || 'INSERT ';
    END IF;

    IF ( SELECT lon_log_update FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname ) THEN
        _triggername_neu := _triggername_neu || 'u';
        IF length( _str ) > 8 THEN
            _str := _str || 'OR ';
        END IF;
        _str := _str || 'UPDATE ';
    END IF;

    SELECT count(*) INTO _rec_count FROM tlog.AuditlogConfig_OF WHERE lof_table = _tname AND lof_logging;
    --- Felder-Liste anlegen
    _OF_i   := 0;
    IF _rec_count > 0 AND ( SELECT count(*) FROM tlog.AuditlogConfig_OF WHERE lof_table = _tname ) <> _rec_count  THEN     --- OF - Felderliste anlegen, wenn reccount > 0 ist
                                                                                                                           --- oder wenn nicht alle Felder von Subtabelle ins Trigger gehen soll,
                                                                                                                           --- sonst keine OF-Kaluse
        _OF_str := 'OF ';
        i       := 0;
        FOR rec IN SELECT * FROM tlog.AuditlogConfig_OF WHERE lof_table = _tname AND lof_logging ORDER BY lof_fieldname LOOP
            i := i + 1;
            _OF_str := _OF_str || rec.lof_fieldname;
            IF i < _rec_count THEN
                _OF_str := _OF_str ||  ', ';
            END IF;
            IF char_length( _OF_str ) > 200 OR i = _rec_count THEN
                IF _OF_i = 0 THEN
                    _str := _str ||  ' '    || _OF_str || chr( 10 );
                ELSE
                    _str := _str ||  '    ' || _OF_str || chr( 10 );
                END IF;
                _OF_i = _OF_i + 1;
                _OF_str := '';
            END IF;
        END LOOP;

    END IF;

    _triggername_neu := _triggername_neu || '__auditlog';

    result := result ||  'CREATE TRIGGER ' || _triggername_neu || chr( 10 );
    result := result || _str;
   -- IF _OF_i = 0 then
   --     result := result || chr( 10 );
   -- END IF;

    IF _schema = 'public' THEN
        result := result ||  ' ON ' || _tname || chr( 10 );
    ELSE
        result := result ||  ' ON ' || _schema || '.' || _tname || chr( 10 );
    END IF;
    result := result ||  ' FOR EACH ROW'  || chr( 10 );

    IF ( SELECT lon_when FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname ) IS NOT null THEN
        result := result || ' ' || ( SELECT lon_when FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname ) || chr( 10 );
    END IF;
    result := result ||  ' EXECUTE PROCEDURE tlog.auditlog_add_record();' || chr( 10 );

    result := result ||  '---' || chr( 10 );

    --- zweites DELETE-Trigger
    result := result ||  'CREATE TRIGGER ' || _tname || '__a_99_d__auditlog' || chr( 10 );
    result := result || ' AFTER DELETE' || chr( 10 );

    IF _schema = 'public' THEN
        result := result ||  ' ON ' || _tname || chr( 10 );
    ELSE
        result := result ||  ' ON ' || _schema || '.' || _tname || chr( 10 );
    END IF;
    result := result ||  ' FOR EACH ROW'  || chr( 10 );

    SELECT lon_when INTO _str FROM tlog.AuditlogConfig_ON WHERE lon_table = _tname;
    _str := replace( _str, 'new.', 'old.' );
    result := result || ' ' || _str || chr( 10 );
    result := result ||  ' EXECUTE PROCEDURE tlog.auditlog_add_record();'; -- || chr( 10 );

    RETURN result;

 END $$ LANGUAGE plpgsql STABLE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog_parent_fname_rec( OUT line_ TEXT, OUT line1_ TEXT ) RETURNS setof record AS $$
 DECLARE rec                 record;
         _max__char_length   integer;

 BEGIN

    SELECT max( char_length( lon_table ) ) + 5 FROM   tlog.AuditlogConfig_ON INTO _max__char_length;
  --  RAISE NOTICE '_max__char_length = %', _max__char_length;

    line1_ := '';

    line_ := 'CREATE OR REPLACE FUNCTION tlog.Auditlog_parent_fname( _tabname varchar ) RETURNS VARCHAR AS ' || chr(36) || chr(36);        RETURN NEXT;
    line_ := '  DECLARE fname varchar;';             RETURN NEXT;
    line_ := '  BEGIN';                              RETURN NEXT;
    line_ := '    CASE _tabname';                    RETURN NEXT;


    FOR rec IN SELECT lon_table, lon_parent_fname
               FROM   tlog.AuditlogConfig_ON
               WHERE  lon_parent_fname IS NOT null
                 AND not lon_inaktiv        --- deaktivierte Tabellen ausschliessen
               ORDER BY lon_table
    LOOP
        line_ := '       WHEN ';
        line_ := line_ || quote_literal( rec.lon_table ) || repeat(' ', _max__char_length - char_length( rec.lon_table ) ) ;
        line_ := line_ || ' THEN fname := ' || quote_literal( rec.lon_parent_fname ) || ';';
        RETURN NEXT;
    END LOOP;
    line_ := '        ELSE                                       fname := null;';  RETURN NEXT;
    line_ := '    END CASE;';                                                      RETURN NEXT;
    line_ := '';                                                                   RETURN NEXT;
    line_ := '    RETURN fname;';                                                  RETURN NEXT;
    line_ := '';                                                                   RETURN NEXT;
    line_ := ' END ' || chr(36) || chr(36) || ' LANGUAGE plpgsql;';                RETURN NEXT;
    --- line_ := '---';                                                                RETURN NEXT;

 END $$ LANGUAGE plpgsql STABLE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident__rec( OUT line_ TEXT, OUT line1_ TEXT ) RETURNS setof record AS $$
 DECLARE rec       record;
         arr       varchar[];
         _schema   varchar := '';

 BEGIN
    line1_ := '';

    line_ := ''; RETURN NEXT;

    line_ := 'SELECT tsystem.function__drop_by_regex( ''auditlog__table__ident'', ''tlog'', _commit => true );'; RETURN NEXT;
    line_ := '---';                                                                                              RETURN NEXT;
    FOR rec IN SELECT lon_table, lon_code_ident
               FROM   tlog.AuditlogConfig_ON
               WHERE  lon_code_ident IS NOT null
                 AND not lon_inaktiv        --- deaktivierte Tabellen ausschliessen
               ORDER BY lon_table
    LOOP

        SELECT table_schema INTO _schema FROM information_schema.tables WHERE table_name = rec.lon_table;

        IF _schema = 'public' THEN
            line_ := 'CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab ' || rec.lon_table || ' ) RETURNS VARCHAR AS ' || chr(36) || chr(36);                    RETURN NEXT;
        ELSE
            line_ := 'CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab '  || _schema || '.' || rec.lon_table || ' ) RETURNS VARCHAR AS ' || chr(36) || chr(36); RETURN NEXT;
        END IF;

        SELECT regexp_split_to_array( rec.lon_code_ident, E'\n') INTO arr;

        FOR i in array_lower(arr, 1)..array_upper(arr, 1) LOOP
            line_ := ' ' || replace( arr[i]::varchar, E'\r', '' );            RETURN NEXT;
        END LOOP;

        line_ := '  ' || chr(36) || chr(36) || ' LANGUAGE sql STABLE PARALLEL SAFE;';       RETURN NEXT;
        line_ := '---';                                                                     RETURN NEXT;

    END LOOP;

 END $$ LANGUAGE plpgsql STABLE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json__rec( OUT line_ TEXT, OUT line1_ TEXT ) RETURNS setof record AS $$
 DECLARE rec       record;
         arr       varchar[];
         _schema   varchar := '';

 BEGIN
    line1_ := '';

    line_ := ''; RETURN NEXT;

    line_ := 'SELECT tsystem.function__drop_by_regex( ''auditlog__table__ident_json'', ''tlog'', _commit => true );'; RETURN NEXT;
    line_ := '---';                                                                                              RETURN NEXT;
    FOR rec IN SELECT lon_table, lon_code_ident_json
               FROM   tlog.AuditlogConfig_ON
               WHERE  lon_code_ident_json IS NOT null
                 AND not lon_inaktiv        --- deaktivierte Tabellen ausschliessen
               ORDER BY lon_table
    LOOP

        SELECT table_schema INTO _schema FROM information_schema.tables WHERE table_name = rec.lon_table;

        IF _schema = 'public' THEN
            line_ := 'CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab ' || rec.lon_table || ' ) RETURNS json AS ' || chr(36) || chr(36);                    RETURN NEXT;
        ELSE
            line_ := 'CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab '  || _schema || '.' || rec.lon_table || ' ) RETURNS json AS ' || chr(36) || chr(36); RETURN NEXT;
        END IF;

        SELECT regexp_split_to_array( rec.lon_code_ident_json, E'\n') INTO arr;

        FOR i in array_lower(arr, 1)..array_upper(arr, 1) LOOP
            line_ := ' ' || replace( arr[i]::varchar, E'\r', '' );            RETURN NEXT;
        END LOOP;

        line_ := '  ' || chr(36) || chr(36) || ' LANGUAGE sql STABLE PARALLEL SAFE;';       RETURN NEXT;
        line_ := '---';                                                                     RETURN NEXT;

    END LOOP;

 END $$ LANGUAGE plpgsql STABLE;
---
CREATE OR REPLACE FUNCTION tlog.tlog_Auditlog__references__get__create__rec( OUT line_ TEXT, OUT line1_ TEXT ) RETURNS setof record AS $$
 DECLARE rec       record;
         arr       varchar[];

 BEGIN

        line_  := 'CREATE OR REPLACE FUNCTION tlog.Auditlog__references__get('; RETURN NEXT;

        line_ := '      _tabname                  varchar,';                    RETURN NEXT;
        line_ := '      _parent_id                varchar = '''',';             RETURN NEXT;
        line_ := '      _old                      varchar = '''',';             RETURN NEXT;
        line_ := '';                                                            RETURN NEXT;
        line_ := '      OUT references_tablename  varchar,';                    RETURN NEXT;
        line_ := '      OUT references_FName      varchar,';                    RETURN NEXT;
        line_ := '      OUT references_id         varchar';                     RETURN NEXT;
        line_ := '  ) RETURNS record AS ' || chr(36) || chr(36);                RETURN NEXT;
        line_ := '  BEGIN';                                                     RETURN NEXT;
        line_ := '    CASE _tabname';                                           RETURN NEXT;


        FOR rec IN SELECT lon_table, lon_code_references__get
                   FROM   tlog.AuditlogConfig_ON
                   WHERE  lon_code_references__get IS NOT null
                     AND not lon_inaktiv        --- deaktivierte Tabellen ausschliessen
                   ORDER BY lon_table
        LOOP
            line_ := '        WHEN '''  || rec.lon_table || ''' THEN';          RETURN NEXT;

            SELECT regexp_split_to_array( rec.lon_code_references__get, E'\n') INTO arr;

            FOR i in array_lower(arr, 1)..array_upper(arr, 1) LOOP
                line_ := replace( arr[i]::varchar, E'\r', '' ); RETURN NEXT;
            END LOOP;
            line_ := '            --REGEX MARKEND--'; RETURN NEXT;

        END LOOP;

        line_ := '        ELSE';   RETURN NEXT;
        line_ := '            references_tablename := null;';                  RETURN NEXT;
        line_ := '            references_FName     := null;';                  RETURN NEXT;
        line_ := '            references_id        := null;';                  RETURN NEXT;
        line_ := '    END CASE;';   RETURN NEXT;
        line_ := '    RETURN;';   RETURN NEXT;
        line_ := '  END ' || chr(36) || chr(36) || ' LANGUAGE plpgsql STABLE;'; RETURN NEXT;
        --- line_ := '';   RETURN NEXT;

 END $$ LANGUAGE plpgsql STABLE;
---

--- Funktion löscht FeldList von Tabelle _tname, dann erstellt neue.
--- Gelogte Felder 'lof_logging' holt von aktuellem Trigger ab
CREATE OR REPLACE FUNCTION tlog.AuditlogConfig_OF__create__by__lof_table( IN _tname varchar ) RETURNS void AS $$
  DECLARE rec                 record;
         _pos_OF             integer;
         _pos_ON             integer;
         _array_OF           varchar[];
         _sql                varchar;
         _lof_logging        boolean;
         _definition         varchar;
 BEGIN

    --- #19572
    DELETE FROM tlog.AuditlogConfig_OF  --- nur löschen, wenn nicht mehr in der Tabelle sind
    WHERE lof_table = _tname
      AND NOT EXISTS ( SELECT true
                       FROM information_schema.columns
                       WHERE table_name = lof_table
                         AND column_name not IN ( 'dbrid', 'insert_by', 'insert_date', 'modified_by', 'modified_date' )
                         AND column_name = lof_fieldname
                         AND coalesce( table_schema, '' ) NOT IN ( 'z_99_drop', 'x_950_import', 'x_900_export' ));

    --- Trigger, als Text, in '_definition' einlesen
    SELECT pg_get_triggerdef(oid)::text INTO _definition
    FROM pg_trigger
    WHERE tgname iLIKE ( _tname ||'__a_99_%' ) AND tgname iLIKE ( '%__auditlog' );

    --- OF-Begrenzung
    _pos_OF := position(' OF ' in _definition );
    _pos_ON := position(' ON ' in _definition );

    --- Feldliste in Array übernehmen
    _array_OF := regexp_split_to_array( substring( _definition from _pos_OF + 4 for _pos_ON - _pos_OF ), ', ' );

    --- Feldnamen durch gehen
    FOR rec IN SELECT column_name
               FROM information_schema.columns
               WHERE table_name = _tname AND column_name not IN ( 'dbrid', 'insert_by', 'insert_date', 'modified_by', 'modified_date' )
    LOOP

        --- Datensatz anlegen
        _sql = 'INSERT INTO tlog.AuditlogConfig_OF ( lof_table, lof_fieldname ) SELECT ' || quote_literal( _tname ) || ',  ' || quote_literal( rec.column_name ) || ' '
            || 'WHERE NOT exists( SELECT true FROM tlog.AuditlogConfig_OF WHERE lof_table = ' || quote_literal( _tname ) || ' AND lof_fieldname = ' || quote_literal( rec.column_name ) || ' );';
        EXECUTE _sql;

        --- überprüfeh, ob aktuelles Feld werden geloggt
        IF _pos_OF = 0 THEN                                                        --- kein OF -> alle Tabellenfelder müssen gelogt werden
            _lof_logging := true;                                                  --- loggen
        ELSE
            IF array_position( _array_OF, rec.column_name::varchar ) > 0 THEN      --- aktuelles Feld existiert in Array_OF-Liste
                _lof_logging := true;                                              --- loggen
            ELSE
                _lof_logging := false;                                             --- nicht loggen
            END IF;
        END IF;

        _sql = 'UPDATE tlog.AuditlogConfig_OF SET lof_logging = ' || _lof_logging::text || ' WHERE lof_table = ' || quote_literal( _tname ) || ' AND lof_fieldname = ' || quote_literal( rec.column_name ) || ';';
        EXECUTE _sql;

    END LOOP;

    --UPDATE tlog.auditlogconfig_on SET lon_trigger_script = ( SELECT tlog.auditlog__table_trigger__from__AuditlogConfig_ON__create__txt( _tname ) ) WHERE lon_table = _tname;

 END $$ LANGUAGE plpgsql;
---
/* GEO
---  Felder-Aktualisierung von Triggers in aktuellem DB
CREATE OR REPLACE FUNCTION tlog.AuditlogConfig_ON__from_pg_trigger__update( IN _tname varchar, IN _when boolean DEFAULT false ) RETURNS void AS $$
 DECLARE rec                 record;
         _sql                varchar;
         _lon_log_insert     boolean;
         _lon_log_update     boolean;
         _lon_log_delete     boolean;
         _when_pos_anf       integer;
         _when_pos_ende      integer;

 BEGIN

    FOR rec IN SELECT                                                 --- Auditlog-Trigger einlesen
                 pg_get_triggerdef(oid)::text AS definition,
                 tgname,
                 substring( tgname from 1 for position( '__a_99' in tgname ) - 1 ) AS tabname
               FROM   pg_trigger
               WHERE tgname iLIKE '%_auditlog'
                 AND _tname = substring( tgname from 1 for position( '__a_99' in tgname ) - 1 )
    LOOP

        _lon_log_insert := position( 'INSERT' in rec.definition ) > 0;
        _lon_log_update := position( 'UPDATE' in rec.definition ) > 0;
        _lon_log_delete := position( 'DELETE' in rec.definition ) > 0;

        UPDATE tlog.auditlogconfig_on
          SET
            lon_log_insert = _lon_log_insert,
            lon_log_update = _lon_log_update,
            lon_log_delete = _lon_log_delete,
            lon_trigger_script = ( SELECT tlog.auditlog__table_trigger__from__AuditlogConfig_ON__create__txt( _tname ) ),
            lon_parent_fname = tlog.Auditlog_parent_fname( _tname )
        WHERE lon_table = _tname;

        UPDATE tlog.auditlogconfig_on SET lon_trigger_script = ( SELECT tlog.auditlog__table_trigger__from__AuditlogConfig_ON__create__txt( _tname ) ) WHERE lon_table = _tname;

        _when_pos_anf  := position( 'WHEN ' in rec.definition );
        _when_pos_ende := position( 'EXECUTE PROCEDURE ' in rec.definition );
        IF _when AND _when_pos_anf > 0 AND _when_pos_ende - _when_pos_anf > 0 THEN
            UPDATE tlog.auditlogconfig_on
              SET lon_when = ' ' || substring( rec.definition FROM _when_pos_anf FOR _when_pos_ende - _when_pos_anf )
            WHERE lon_table = _tname;
        END IF;

    END LOOP;
 END $$ LANGUAGE plpgsql;
---
*/

CREATE OR REPLACE FUNCTION tlog.Auditlog___lon_code_references__get__from__funktion( _tabname varchar )
  RETURNS varchar
  AS $$
  DECLARE _array                     varchar[];
          _sql                       text;
          rec                        record;
  BEGIN

    _sql := '';
    FOR rec IN ( SELECT  regexp_matches( ( SELECT pg_get_functiondef( oid )
                                           FROM pg_catalog.pg_proc
                                           WHERE proname iLIKE 'Auditlog__references__get'
                                         ), '(?<=WHEN).*?(?=--REGEX MARKEND--)', 'gsi'
                                       )::varchar AS code_references__get

               ) LOOP
          IF position( '''' || _tabname || ''' THEN' in rec.code_references__get::varchar ) > 0 THEN
              SELECT regexp_split_to_array( rec.code_references__get, E'\n') INTO _array;
              FOR i in array_lower(_array, 1)..array_upper(_array, 1) LOOP
                  IF position( '''' || _tabname || '''' in _array[i]::varchar ) = 0
                     AND position( '}' in _array[i]::varchar ) = 0
                     AND char_length( _array[i]::varchar ) > 0
                  THEN
                      _sql := _sql || _array[i]::varchar || chr( 10 );
                  END IF;

              END LOOP;
              RETURN _sql;
          END IF;
    END LOOP;

    RETURN null;
 END $$ LANGUAGE plpgsql VOLATILE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog___lon_code_ident__from__funktion( _tabname varchar )
  RETURNS varchar
  AS $$
  DECLARE _lon_code_ident            text     := null;
  BEGIN

    SELECT replace( replace( prosrc, 'BEGIN', '' ), 'END', '' )
    INTO _lon_code_ident
    FROM pg_catalog.pg_proc
    WHERE proname iLIKE 'Auditlog__table__ident'
      AND pg_get_functiondef(oid) iLIKE '%(_tab ' || _tabname || ')%';
    _lon_code_ident := repeat(' ', 4 ) || substring( _lon_code_ident FROM position( ' RETURN' in _lon_code_ident ) );

    RETURN _lon_code_ident;

  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tlog.Auditlog_funktion_rec__to__text( IN _funkname varchar ) RETURNS text AS $$
   DECLARE  _sql    text := '';
            rec     record;
  BEGIN
    FOR rec IN EXECUTE 'SELECT line_ FROM tlog.' || _funkname
    LOOP
        _sql := _sql || rec.line_ || chr( 10 );
    END LOOP;

    RETURN _sql;
  END $$ LANGUAGE plpgsql STABLE;


--- DBU erstellen: Eingangsparameter - Funktionsname, Ausgangsparameter - SQL als Text
---      PRODAT DBU's werden im Knote '99.99.99 DEVELOP-Zweig \  prodat-next \ als gesperrt angelegt
CREATE OR REPLACE FUNCTION tlog.Auditlog_funktion_rec__DBU__create(
    IN _funkname       varchar,
    IN _upd_parent     varchar,
    IN _upd_minver     varchar,
    IN _upd_projekt    varchar,
    IN _upd_sperr      boolean
    ) RETURNS void AS $$
  DECLARE  _sql          text           := '';
           _upd_bez      varchar( 150 ) := _funkname;   --- DBU Bezeichnung

  BEGIN

    CASE _funkname
         WHEN 'Auditlog__table__ident__rec()'                                                THEN _upd_bez := 'Auditlog__table__ident'      || ' ( autogenerated )';
     WHEN 'Auditlog__table__ident_json__rec()'                                           THEN _upd_bez := 'Auditlog__table__ident_json' || ' ( autogenerated )';
         WHEN 'tlog_Auditlog__references__get__create__rec()'                                THEN _upd_bez := 'Auditlog__references__get'   || ' ( autogenerated )';
         WHEN 'Auditlog_parent_fname_rec()'                                                  THEN _upd_bez := 'Auditlog_parent_fname'       || ' ( autogenerated )';
         WHEN 'auditlog__table_trigger__from__AuditlogConfig_ON__create__rec( null, true)'   THEN _upd_bez := 'Auditlog__Triggers'          || ' ( autogenerated )';
      ELSE
         _upd_bez = 'FEHLER!!! FUNCTION tlog.Auditlog_funktion_rec__DBU__create(): nicht definiert';
    END CASE;

    PERFORM  pg_sleep(1);                             --- Zeitverzögerung

    SELECT tlog.Auditlog_funktion_rec__to__text( _funkname ) INTO _sql;

    INSERT INTO dbupdates (                                              upd_id, upd_parent,   upd_minver,  upd_bez, upd_sql, upd_sperr , upd_projekt  )
     VALUES               ( to_char(clock_timestamp(), 'YYYY-MM-DD HH24:MI:SS'), _upd_parent, _upd_minver, _upd_bez,   _sql, _upd_sperr, _upd_projekt );
  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog_funktion_rec__DBU_komplett__create(
    IN _knote_bez      varchar ='#00000',
    IN _upd_minver     varchar = '00.00.00.00',
    IN _upd_projekt    varchar ='00000',
    IN _upd_sperr      boolean = true
    ) RETURNS void AS $$
  DECLARE  _sql          text := '';
           _upd_parent   varchar( 30 )  := '2999-04-03 22:21:34';  --- 'Auditlog Config ( autogenerated )' - upd_id
  BEGIN

    --- Knote erstellen
    INSERT INTO dbupdates (                                              upd_id,  upd_parent,  upd_minver,    upd_bez, upd_sql, upd_sperr , upd_projekt )
     VALUES               ( to_char(clock_timestamp(), 'YYYY-MM-DD HH24:MI:SS'), _upd_parent, _upd_minver, _knote_bez,   null, _upd_sperr, _upd_projekt )
    RETURNING upd_id INTO _upd_parent;
    ---

    --- DBU Funktion  tlog.Auditlog__table__ident__rec()
    PERFORM tlog.Auditlog_funktion_rec__DBU__create( 'Auditlog__table__ident__rec()', _upd_parent, _upd_minver, _upd_projekt, _upd_sperr );

    --- DBU Funktion  tlog.Auditlog__table__ident_json__rec()
    PERFORM tlog.Auditlog_funktion_rec__DBU__create( 'Auditlog__table__ident_json__rec()', _upd_parent, _upd_minver, _upd_projekt, _upd_sperr );

    --- DBU Funktion  tlog.tlog_Auditlog__references__get__create__rec()
    PERFORM tlog.Auditlog_funktion_rec__DBU__create( 'tlog_Auditlog__references__get__create__rec()', _upd_parent, _upd_minver, _upd_projekt, _upd_sperr );

    --- DBU Funktion  tlog.Auditlog_parent_fname_rec()
    PERFORM tlog.Auditlog_funktion_rec__DBU__create( 'Auditlog_parent_fname_rec()', _upd_parent, _upd_minver, _upd_projekt, _upd_sperr );

    --- DBU Funktion  tlog.auditlog__table_trigger__from__AuditlogConfig_ON__create__rec( null, true)
    PERFORM tlog.Auditlog_funktion_rec__DBU__create( 'auditlog__table_trigger__from__AuditlogConfig_ON__create__rec( null, true)', _upd_parent, _upd_minver, _upd_projekt, _upd_sperr );

  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tlog.tlog_auditlog__create__dbu__triggers__funktionen() RETURNS text AS $$
 DECLARE txt_     text := '' || chr( 10 );
         rec      record;
 BEGIN

    FOR rec IN SELECT line_ FROM tlog.tlog_Auditlog__references__get__create__rec() LOOP
        txt_ := txt_ || rec.line_ || chr( 10 );
    END LOOP;
    txt_ := txt_ || repeat('-', 30) || chr( 10 );

    FOR rec IN SELECT line_ FROM tlog.Auditlog__table__ident__rec() LOOP
        txt_ := txt_ || rec.line_ || chr( 10 );
    END LOOP;
    txt_ := txt_ || repeat('-', 30) || chr( 10 );

    FOR rec IN SELECT line_ FROM tlog.Auditlog_parent_fname_rec() LOOP
        txt_ := txt_ || rec.line_ || chr( 10 );
    END LOOP;
    txt_ := txt_ || repeat('-', 30) || chr( 10 );


    FOR rec IN SELECT line_ FROM tlog.auditlog__table_trigger__from__auditlogconfig_on__create__rec( null, true ) LOOP
        txt_ := txt_ || rec.line_ || chr( 10 );
    END LOOP;

    RETURN txt_;

 END $$  LANGUAGE plpgsql STABLE;
---
--- #18880 Funktion erstellt INSERT INTO Scriptvon JSON als eine Zeile von JSON, zum Wiederherstellen eines Datensatzes. Aus der Auditlog/JSon (beliebig). zB auch zum Kopieren von Tabelle
--- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Auditlog-Config#section-3
CREATE OR REPLACE FUNCTION tsystem.insert_into__from__json__in_line(
        IN l_tablename     varchar,
        IN l_json_old      json         --- aktueller JSON
    )  RETURNS text AS $$

  DECLARE
      _rec         record;
      _sql_insert  text;         --- INSERT INTO Script
      _sql_values  text;         --- VALUES Script
      --- JSON-Elemente gesamte Anzahl
      _count       integer;
      --- laufender Datensatz
      _i           integer := 0;
  BEGIN

    --- gesamte JSON-Elementenanzahl, ohne Information-Info
    _count := count(*)
      FROM (
        SELECT key FROM (
            SELECT * FROM json_each_text( l_json_old )
        ) AS sub
        WHERE key NOT IN ( 'dbrid', 'insert_date', 'insert_by', 'modified_date', 'modified_by' )
        AND ( value IS NOT null OR value <> 'null' )
        AND  value <> '0.0000'
        AND key NOT iLIKE '%_rtf'
    ) AS sub1;

    _sql_insert := 'INSERT INTO ' || replace( l_tablename, 'public.', '' ) || '(' ; ---|| chr(10);
    _sql_values := '  VALUES ( '; --- || chr(10);

    --- JSON als Record: feldname, value_old ( ohne Information-Info ) durchlaufen
    FOR _rec IN
        SELECT
          key,      --- Feldname
          value     --- Wert
        FROM (
          SELECT *
          FROM json_each_text( l_json_old )
        ) AS sub
        WHERE key NOT IN ( 'dbrid', 'insert_date', 'insert_by', 'modified_date', 'modified_by' )
          AND ( value IS NOT null OR value <> 'null' )
          AND  value <> '0.0000'
          AND key NOT iLIKE '%_rtf'
    LOOP
      _i := _i + 1;
      --- rec.key -> Feldname
      _sql_insert  :=            --- INSERT Script sammeln
          _sql_insert
          || ' '
          || _rec.key
          --- beim letzte Datensatz, Koma soll nicht erstellt werden
          || CASE WHEN _i < _count THEN ',' ELSE ' ' END              --- Komma setzen, wenn kein letztes JSON-Element
          ;

      --- rec.value -> Wert
      _sql_values  :=            --- VALUES Script sammeln
          _sql_values
          || ' '
          || coalesce( quote_literal( _rec.value ), 'null' )
          --- beim letzte Datensatz, Koma soll nicht erstellt werden
          || CASE WHEN _i < _count THEN ',' ELSE ' ' END              --- Komma setzen, wenn kein letztes JSON-Element
          ;

    END LOOP;

    --- beise Scripte zusammenbilden
    RETURN _sql_insert || ')' || chr(10) || _sql_values || ')' || ';';
  END $$ LANGUAGE plpgsql STABLE;
---
--- Funktion erstellt INSERT INTO Script von Tabelleninhalt auditlogconfig_on und auditlogconfig_of
CREATE OR REPLACE FUNCTION tlog.INSERT_statament__from__auditlogconfig_on_of()
    RETURNS table (
                    _id     integer,
                    _result text
                  )AS $$
  DECLARE  _json        json;
           _tmp         record;
           _sql         text;
           rec          record;
           _json1       json;
           _tmp1        record;
           rec1         record;
           i            integer := 0;

           ---_array       varchar[];
  BEGIN
    --- Trigger deaktivieren, dass beim auditlogconfig_on anlegen, in auditlogconfig_of nicht's angelegt wird
    _result := 'ALTER TABLE tlog.auditlogconfig_on DISABLE TRIGGER auditlogconfig_on__a_99_i__insert__auditlogconfig_of;';
    i := i + 1;
    _id = i;
    RETURN NEXT;
    _result := '---';
    i := i + 1;
    _id = i;
    RETURN NEXT;

    FOR rec IN SELECT lon_table FROM tlog.auditlogconfig_on LOOP   --- Tabelle durch gehen

        --- JSON erstellen
        EXECUTE 'SELECT * FROM tlog.auditlogconfig_on WHERE lon_table = ' || quote_literal( rec.lon_table ) || ' ' INTO _tmp;
        SELECT row_to_json( _tmp ) INTO _json;

        --- Modified-Spalten
        SELECT tlog.json__value__dbrid_insert_modified__replace( _json ) INTO _json;

        --- INSERT-Statament erstellen
        SELECT TSystem.insert_into__from__json__in_line( 'tlog.auditlogconfig_on', _json ) INTO _sql;

        --- INSERT-Statament korrigieren
        _sql := replace( _sql, ')\n ', ') ' );
        _sql := replace( _sql, '''false''', 'false' );
        _sql := replace( _sql, '''true''', 'true' );
        _result := _sql;
        i := i + 1;
        _id = i;
        ---
        RETURN NEXT;

        FOR rec1 IN SELECT lof_fieldname FROM tlog.auditlogconfig_of WHERE lof_table = rec.lon_table LOOP  --- nur von master lof_table=rec.lon_table
            --- JSON erstellen
            EXECUTE 'SELECT * FROM tlog.auditlogconfig_of WHERE lof_table = ' || quote_literal( rec.lon_table ) || ' AND lof_fieldname = ' || quote_literal( rec1.lof_fieldname ) || ' ' INTO _tmp1;
            SELECT row_to_json( _tmp1 ) INTO _json1;

            --- Modified-Spalten
            SELECT tlog.json__value__dbrid_insert_modified__replace( _json1 ) INTO _json1;

            --- INSERT-Statament erstellen
            SELECT TSystem.insert_into__from__json__in_line( 'tlog.auditlogconfig_of', _json1 ) INTO _sql;

            --- INSERT-Statament korrigieren
            _sql := replace( _sql, ')\n ', ') ' );
            _sql := replace( _sql, '''false''', 'false' );
            _sql := replace( _sql, '''true''', 'true' );
            _result := _sql;
            i := i + 1;
            _id = i;
            ---
            RETURN NEXT;

        END LOOP;
        i := i + 1;
        _id = i;
        _result := '---';
        RETURN NEXT;

    END LOOP;

    --- Trigger aktivieren
    _result := 'ALTER TABLE tlog.auditlogconfig_on ENABLE TRIGGER auditlogconfig_on__a_99_i__insert__auditlogconfig_of;';
    i := i + 1;
    _id = i;
    RETURN NEXT;

  END $$ LANGUAGE plpgsql;